"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdminService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const vendor_entity_1 = require("../../entities/vendor.entity");
const user_entity_1 = require("../../entities/user.entity");
const product_entity_1 = require("../../entities/product.entity");
const order_entity_1 = require("../../entities/order.entity");
let AdminService = class AdminService {
    vendorRepo;
    userRepo;
    productRepo;
    orderRepo;
    constructor(vendorRepo, userRepo, productRepo, orderRepo) {
        this.vendorRepo = vendorRepo;
        this.userRepo = userRepo;
        this.productRepo = productRepo;
        this.orderRepo = orderRepo;
    }
    async getAllVendors() {
        return await this.vendorRepo.find({
            relations: ['user'],
            select: {
                id: true,
                name: true,
                email: true,
                phone: true,
                isApproved: true,
                createdAt: true,
                user: {
                    id: true,
                    email: true,
                    role: true,
                },
            },
        });
    }
    async getVendorById(id) {
        const vendor = await this.vendorRepo.findOne({
            where: { id },
            relations: ['user', 'products'],
        });
        if (!vendor) {
            throw new common_1.NotFoundException(`Vendor with ID ${id} not found`);
        }
        return vendor;
    }
    async updateVendorStatus(id, updateVendorStatusDto) {
        const vendor = await this.vendorRepo.findOne({ where: { id } });
        if (!vendor) {
            throw new common_1.NotFoundException(`Vendor with ID ${id} not found`);
        }
        vendor.isApproved = updateVendorStatusDto.isApproved;
        if (updateVendorStatusDto.approvalNotes !== undefined) {
            vendor.approvalNotes = updateVendorStatusDto.approvalNotes;
        }
        return await this.vendorRepo.save(vendor);
    }
    async getDashboardStats() {
        const [totalVendors, totalCustomers, totalProducts, totalOrders, pendingVendors, recentOrders,] = await Promise.all([
            this.vendorRepo.count(),
            this.userRepo.count({ where: { role: 'customer' } }),
            this.productRepo.count(),
            this.orderRepo.count(),
            this.vendorRepo.count({ where: { isApproved: false } }),
            this.orderRepo.find({
                take: 10,
                order: { createdAt: 'DESC' },
                relations: ['customer'],
            }),
        ]);
        return {
            totals: {
                vendors: totalVendors,
                customers: totalCustomers,
                products: totalProducts,
                orders: totalOrders,
                pendingVendors,
            },
            recentOrders,
            chartData: await this.getChartData(),
        };
    }
    async getChartData() {
        const thirtyDaysAgo = new Date();
        thirtyDaysAgo.setDate(thirtyDaysAgo.getDate() - 30);
        const recentOrders = await this.orderRepo
            .createQueryBuilder('order')
            .where('order.createdAt >= :date', { date: thirtyDaysAgo })
            .select('DATE(order.createdAt)', 'date')
            .addSelect('COUNT(*)', 'count')
            .groupBy('DATE(order.createdAt)')
            .orderBy('date', 'ASC')
            .getRawMany();
        return {
            orders: recentOrders,
        };
    }
    async createProduct(createProductDto) {
        const vendor = await this.vendorRepo.findOne({
            where: { id: String(createProductDto.vendorId) }
        });
        if (!vendor) {
            throw new common_1.NotFoundException(`Vendor with ID ${createProductDto.vendorId} not found`);
        }
        const { vendorId, ...rest } = createProductDto;
        const product = this.productRepo.create({
            ...rest,
            vendorId: vendor.id,
        });
        return await this.productRepo.save(product);
    }
    async updateProduct(id, updateProductDto) {
        const product = await this.productRepo.findOne({ where: { id: Number(id) } });
        if (!product) {
            throw new common_1.NotFoundException(`Product with ID ${id} not found`);
        }
        Object.assign(product, updateProductDto);
        return await this.productRepo.save(product);
    }
    async deleteProduct(id) {
        const result = await this.productRepo.delete(id);
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Product with ID ${id} not found`);
        }
    }
    async getPendingVendors() {
        return await this.vendorRepo.find({
            where: { isApproved: false },
            relations: ['user'],
        });
    }
    async approveVendor(id, notes) {
        const vendor = await this.vendorRepo.findOne({ where: { id } });
        if (!vendor) {
            throw new common_1.NotFoundException(`Vendor with ID ${id} not found`);
        }
        vendor.isApproved = true;
        if (notes) {
            vendor.approvalNotes = notes;
        }
        return await this.vendorRepo.save(vendor);
    }
    async rejectVendor(id, reason) {
        const vendor = await this.vendorRepo.findOne({ where: { id } });
        if (!vendor) {
            throw new common_1.NotFoundException(`Vendor with ID ${id} not found`);
        }
        vendor.isApproved = false;
        vendor.approvalNotes = reason;
        return await this.vendorRepo.save(vendor);
    }
    async getAllUsers() {
        return await this.userRepo.find({
            select: ['id', 'email', 'role', 'createdAt', 'updatedAt']
        });
    }
    async getUserById(id) {
        const user = await this.userRepo.findOne({
            where: { id },
            relations: ['vendor']
        });
        if (!user) {
            throw new common_1.NotFoundException(`User with ID ${id} not found`);
        }
        return user;
    }
    async updateUserRole(id, role) {
        const user = await this.userRepo.findOne({ where: { id } });
        if (!user) {
            throw new common_1.NotFoundException(`User with ID ${id} not found`);
        }
        user.role = role;
        return await this.userRepo.save(user);
    }
};
exports.AdminService = AdminService;
exports.AdminService = AdminService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(vendor_entity_1.Vendor)),
    __param(1, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __param(2, (0, typeorm_1.InjectRepository)(product_entity_1.Product)),
    __param(3, (0, typeorm_1.InjectRepository)(order_entity_1.Order)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository])
], AdminService);
//# sourceMappingURL=admin.service.js.map